<?php
ini_set('memory_limit', '256M');
ob_start('ob_gzhandler');
header("Content-type: text/javascript");
if (is_ajax()) {    
  if (isset($_REQUEST["action"]) && !empty($_REQUEST["action"])) { //Checks if action value exists
    $action = $_REQUEST["action"];
    $date_from = $_REQUEST["dateFrom"];
    switch($action) { //Switch case for value of action
      case "pressure": 
        pressure_function($date_from); 
        break;
    }
  }
}

//Function to check if the request is an AJAX request
function is_ajax() { 
  return 1;
}

function getPressureStats($passedDateFrom){
  $link = mysqli_connect("localhost", "fazziind_sqcroot", "SqcSys123", "fazziind_sqc");
  $result = mysqli_query($link, "SELECT count(VALUE) as quanti, avg(value) as pressioneMedia,
  max(value) as pressioneMassima, min(value) as pressioneMinima   
  FROM PRESSURES p
  WHERE 
  CAST(DATE_ADD(p.`DATETIME`, INTERVAL 6 HOUR) as DATE) = '$passedDateFrom'") or die(mysqli_error($link));
  $pressure = array();
  while($row = mysqli_fetch_assoc( $result )) {
     $pressure[] = $row;
  }
  //ob_end_flush();
  mysqli_close($link);
  return $pressure;
}

function getPressureDays(){
  $link = mysqli_connect("localhost", "fazziind_sqcroot", "SqcSys123", "fazziind_sqc");
  $result = mysqli_query($link, "SELECT CAST(DATE_ADD(p.`DATETIME`, INTERVAL 7 HOUR) as DATE) DateOnly
  FROM PRESSURES p
  GROUP BY CAST(DATE_ADD(p.`DATETIME`, INTERVAL 7 HOUR) as DATE)
  ORDER BY CAST(DATE_ADD(p.`DATETIME`, INTERVAL 7 HOUR) as DATE) desc") or die(mysqli_error($link));
  $pressure = array();
  while($row = mysqli_fetch_assoc( $result )) {
     $pressure[] = $row;
  }
  //ob_end_flush();
  mysqli_close($link);
  return $pressure;
}

function getPressures($passedDateFrom){
  $sliceSeconds=150;
  $link = mysqli_connect("localhost", "fazziind_sqcroot", "SqcSys123", "fazziind_sqc");
  
  $result = mysqli_query($link, "SELECT round(MAX(VALUE),2) as pressure,  
  DATE_FORMAT(CONVERT_TZ(FROM_UNIXTIME(ROUND((FLOOR(UNIX_TIMESTAMP(p.`DATETIME`) 
  / $sliceSeconds) * $sliceSeconds))),'+00:00','+06:00'),\"%Y-%m-%dT%TZ\") as measuredDateTime FROM PRESSURES p 
  WHERE 
  CAST(DATE_ADD(p.`DATETIME`, INTERVAL 7 HOUR) as DATE) = '$passedDateFrom'
  GROUP BY ROUND((FLOOR(UNIX_TIMESTAMP(p.`DATETIME`) / $sliceSeconds) * $sliceSeconds)) 
  ORDER BY ROUND((FLOOR(UNIX_TIMESTAMP(p.`DATETIME`) / $sliceSeconds) * $sliceSeconds))") or die(mysqli_error($link)); 
  $pressure = array();
  while($row = mysqli_fetch_assoc( $result )) {
     $pressure[] = $row;
  }
  //ob_end_flush();
  mysqli_close($link);
  return $pressure;
}

function pressure_function($passedDateFrom){
    $dateArray = array();  
    foreach (getPressureDays() as $value)  {
        $dateArray[] = $value['DateOnly'];
    };
    
    $innerArray = array();
    $pressureStats = array();
    if($passedDateFrom!=null && ISSET($passedDateFrom))
    {
      $pressureStats = getPressureStats($passedDateFrom)[0];
      foreach (getPressures($passedDateFrom) as $value)  {
          $innerArray[] = array(
                      "pressure" => $value['pressure'] ,
                      "measuredDateTime" => $value['measuredDateTime']
              );
      };
    }
    
    
    
    $arr = array(
          "quanti" => $pressureStats['quanti'] ,
          "pressioneMedia" => $pressureStats['pressioneMedia'] ,
          "pressioneMassima" => $pressureStats['pressioneMassima'] ,
          "date" => $dateArray,    
          "content" => $innerArray  
    );
    /* encode the array as json. this will output [{"first_name":"Darian","last_name":"Brown","age":"28","email":"darianbr@example.com"},{"first_name":"John","last_name":"Doe","age":"47","email":"john_doe@example.com"}] */
    echo json_encode($arr);
}
?>