<?php
header("Content-type: text/javascript");
if (is_ajax()) {    
  if (isset($_REQUEST["action"]) && !empty($_REQUEST["action"])) { //Checks if action value exists
    
    $action = $_REQUEST["action"];
    switch($action) { //Switch case for value of action
      case "pressure": pressure_function(); break;
      case "liters": liters_function(); break;
      case "temperature": temperature_function(); break;
      case "commands":
        $command_id = $_REQUEST["command_id"]; 
        $value = $_REQUEST["value"]; 
        $value2 = $_REQUEST["value2"]; 
        command_function($command_id,$value,$value2); 
        break;
    }
  }
}
//Function to check if the request is an AJAX request
function is_ajax() { 
  return 1;
}

function getLastPressure(){
  $link = mysqli_connect("localhost", "fazziind_sqcroot", "SqcSys123", "fazziind_sqc");
  $result = mysqli_query($link, "SELECT VALUE as pressure,  DATE_FORMAT(CONVERT_TZ(DATETIME,'+00:00','+06:00'),\"%Y-%m-%dT%TZ\") as lastMeasured, DATE_FORMAT(CONVERT_TZ(CURRENT_TIMESTAMP,'+00:00','+06:00'),\"%Y-%m-%dT%TZ\") as requestDateTime FROM PRESSURES ORDER BY DATETIME DESC LIMIT 0,1") or die(mysqli_error($link)); 
  while($temps = mysqli_fetch_array( $result )) {
     $pressure = $temps;
  }  
  mysqli_close($link);
  return $pressure;
}

function getLastTemperature(){
  $link = mysqli_connect("localhost", "fazziind_sqcroot", "SqcSys123", "fazziind_sqc");
  $result = mysqli_query($link, "SELECT VALUE as tempInterna, VALUE2 as tempCooler,  DATE_FORMAT(CONVERT_TZ(DATETIME,'+00:00','+06:00'),\"%Y-%m-%dT%TZ\") as lastMeasured, DATE_FORMAT(CONVERT_TZ(CURRENT_TIMESTAMP,'+00:00','+06:00'),\"%Y-%m-%dT%TZ\") as requestDateTime FROM TEMPERATURES ORDER BY DATETIME DESC LIMIT 0,1") or die(mysqli_error($link)); 
  while($temps = mysqli_fetch_array( $result )) {
     $temperature = $temps;
  }  
  mysqli_close($link);
  return $temperature;
}

function getLastLiters(){
  $link = mysqli_connect("localhost", "fazziind_sqcroot", "SqcSys123", "fazziind_sqc");
  $result = mysqli_query($link, "SELECT VALUE as liters,  DATE_FORMAT(CONVERT_TZ(DATETIME,'+00:00','+06:00'),\"%Y-%m-%dT%TZ\") as lastMeasured, DATE_FORMAT(CONVERT_TZ(CURRENT_TIMESTAMP,'+00:00','+06:00'),\"%Y-%m-%dT%TZ\") as requestDateTime FROM LITERS ORDER BY DATETIME DESC LIMIT 0,1") or die(mysqli_error($link)); 
  while($temps = mysqli_fetch_array( $result )) {
     $liters = $temps;
  }  
  mysqli_close($link);
  return $liters;
}

function liters_function(){
    $array = getLastLiters();
    /* our multidimentional php array to pass back to javascript via ajax */
    $arr = array(
            array(
                    "liters" => $array['liters'] ,
                    "lastMeasured" => $array['lastMeasured'] ,
                    "requestDateTime" => $array['requestDateTime'] ,
            ),
    );
    
    /* encode the array as json. this will output [{"first_name":"Darian","last_name":"Brown","age":"28","email":"darianbr@example.com"},{"first_name":"John","last_name":"Doe","age":"47","email":"john_doe@example.com"}] */
    echo json_encode($arr);
}

function pressure_function(){
    $array = getLastPressure();
    /* our multidimentional php array to pass back to javascript via ajax */
    $arr = array(
            array(
                    "pressure" => $array['pressure'] ,
                    "lastMeasured" => $array['lastMeasured'] ,
                    "requestDateTime" => $array['requestDateTime'] ,
            ),
    );
    
    /* encode the array as json. this will output [{"first_name":"Darian","last_name":"Brown","age":"28","email":"darianbr@example.com"},{"first_name":"John","last_name":"Doe","age":"47","email":"john_doe@example.com"}] */
    echo json_encode($arr);
}

function temperature_function(){

    $array = getLastTemperature();
    /* our multidimentional php array to pass back to javascript via ajax */
    $arr = array(
            array(
                    "tempInterna" => $array['tempInterna'] ,
                    "tempCooler" => $array['tempCooler'] ,
                    "lastMeasured" => $array['lastMeasured'] ,
                    "requestDateTime" => $array['requestDateTime'] ,
            ),
    );
    
    /* encode the array as json. this will output [{"first_name":"Darian","last_name":"Brown","age":"28","email":"darianbr@example.com"},{"first_name":"John","last_name":"Doe","age":"47","email":"john_doe@example.com"}] */
    echo json_encode($arr);
}

function command_function($commandID, $value, $value2){
    $link = mysqli_connect("localhost", "fazziind_sqcroot", "SqcSys123", "fazziind_sqc");
   
  
    $sql = "INSERT INTO `COMMAND_QUEUE` (`ID`, `MACHINE_ID`, `COMMAND_ID`, `VALUE`, `VALUE2`, `DATETIME`, `executed`) VALUES (NULL, '1', '$commandID', '$value', '$value2', CURRENT_TIMESTAMP, '0');";
    /* our multidimentional php array to pass back to javascript via ajax */
    $result = "";
    if(!mysqli_query($link, $sql)){
      $result = "ERROR: Could not able to execute $sql. " . mysqli_error($link);
    }
    else{
      $result = "Command sent (value: $value, value: $value2)!";
    }      
    $arr = array(
            array(
                    "ok" =>  $result,                    
            ),
    );
  mysqli_close($link);  
    /* encode the array as json. this will output [{"first_name":"Darian","last_name":"Brown","age":"28","email":"darianbr@example.com"},{"first_name":"John","last_name":"Doe","age":"47","email":"john_doe@example.com"}] */
    echo json_encode($arr);
}

?>